package cn.gintone.service;

import cn.gintone.controller.vo.ImportantFilePageReqVO;
import cn.gintone.controller.vo.ImportantFileSaveReqVO;
import cn.gintone.entity.ImportantFileDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;

import javax.validation.*;

/**
 * 重要文件 Service 接口
 *
 * @author 胡懿
 */
public interface ImportantFileService {

    /**
     * 创建重要文件
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createImportantFile(@Valid ImportantFileSaveReqVO createReqVO);

    /**
     * 更新重要文件
     *
     * @param updateReqVO 更新信息
     */
    void updateImportantFile(@Valid ImportantFileSaveReqVO updateReqVO);

    /**
     * 删除重要文件
     *
     * @param id 编号
     */
    void deleteImportantFile(Long id);

    /**
     * 获得重要文件
     *
     * @param id 编号
     * @return 重要文件
     */
    ImportantFileDO getImportantFile(Long id);

    /**
     * 获得重要文件分页
     *
     * @param pageReqVO 分页查询
     * @return 重要文件分页
     */
    PageResult<ImportantFileDO> getImportantFilePage(ImportantFilePageReqVO pageReqVO);

}