package cn.gintone.dal;

import cn.gintone.controller.vo.VisitInfoPageReqVO;
import cn.gintone.controller.vo.VisitInfoRespVO;
import cn.gintone.entity.VisitInfoDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 访问规则配置 Mapper
 *
 * @author 胡懿
 */
@Mapper
public interface VisitInfoMapper extends BaseMapperX<VisitInfoDO> {

    default PageResult<VisitInfoDO> selectPage(VisitInfoPageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<VisitInfoDO>()
                .eqIfPresent(VisitInfoDO::getVisitId, reqVO.getVisitId())
                .eqIfPresent(VisitInfoDO::getSysAbbre, reqVO.getSysAbbre())
                .likeIfPresent(VisitInfoDO::getSysAbbreName, reqVO.getSysAbbreName())
                .likeIfPresent(VisitInfoDO::getUrlName, reqVO.getUrlName())
                .eqIfPresent(VisitInfoDO::getUrl, reqVO.getUrl())
                .eqIfPresent(VisitInfoDO::getUrlId, reqVO.getUrlId())
                .eqIfPresent(VisitInfoDO::getRoleId, reqVO.getRoleId())
                .likeIfPresent(VisitInfoDO::getRoleName, reqVO.getRoleName())
                .eqIfPresent(VisitInfoDO::getUserId, reqVO.getUserId())
                .likeIfPresent(VisitInfoDO::getUserName, reqVO.getUserName())
                .betweenIfPresent(VisitInfoDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(VisitInfoDO::getId));
    }

    default List<VisitInfoDO> selectList(VisitInfoPageReqVO reqVO) {
        List<VisitInfoDO> visitInfoDOS = selectList(new LambdaQueryWrapperX<VisitInfoDO>()
                .eqIfPresent(VisitInfoDO::getVisitId, reqVO.getVisitId())
                .eqIfPresent(VisitInfoDO::getSysAbbre, reqVO.getSysAbbre())
                .likeIfPresent(VisitInfoDO::getSysAbbreName, reqVO.getSysAbbreName())
                .likeIfPresent(VisitInfoDO::getUrlName, reqVO.getUrlName())
                .eqIfPresent(VisitInfoDO::getUrl, reqVO.getUrl())
                .eqIfPresent(VisitInfoDO::getUrlId, reqVO.getUrlId())
                .eqIfPresent(VisitInfoDO::getRoleId, reqVO.getRoleId())
                .likeIfPresent(VisitInfoDO::getRoleName, reqVO.getRoleName())
                .eqIfPresent(VisitInfoDO::getUserId, reqVO.getUserId())
                .likeIfPresent(VisitInfoDO::getUserName, reqVO.getUserName())
                .betweenIfPresent(VisitInfoDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(VisitInfoDO::getId));
        return visitInfoDOS;
    }

}