package cn.gintone.dal;

import java.util.*;

import cn.gintone.controller.vo.ImportantFilePageReqVO;
import cn.gintone.entity.ImportantFileDO;
import cn.iocoder.yudao.framework.common.pojo.PageResult;
import cn.iocoder.yudao.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.yudao.framework.mybatis.core.query.LambdaQueryWrapperX;
import org.apache.ibatis.annotations.Mapper;

/**
 * 重要文件 Mapper
 *
 * @author 胡懿
 */
@Mapper
public interface ImportantFileMapper extends BaseMapperX<ImportantFileDO> {

    default PageResult<ImportantFileDO> selectPage(ImportantFilePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<ImportantFileDO>()
                .likeIfPresent(ImportantFileDO::getName, reqVO.getName())
                .eqIfPresent(ImportantFileDO::getUrl, reqVO.getUrl())
                .eqIfPresent(ImportantFileDO::getPrivateKey, reqVO.getPrivateKey())
                .betweenIfPresent(ImportantFileDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(ImportantFileDO::getId));
    }

}