import request from '@/utils/request'

// 查询出库单主列表
export function listWmsOutboundOrder(query) {
  return request({
    url: '/ware/wmsOutboundOrder/list',
    method: 'get',
    params: query
  })
}

// 查询出库单主详细
export function getWmsOutboundOrder(orderId) {
  return request({
    url: '/ware/wmsOutboundOrder/' + orderId,
    method: 'get'
  })
}

// 新增出库单主
export function addWmsOutboundOrder(data) {
  return request({
    url: '/ware/wmsOutboundOrder',
    method: 'post',
    data: data
  })
}

// 修改出库单主
export function updateWmsOutboundOrder(data) {
  return request({
    url: '/ware/wmsOutboundOrder',
    method: 'put',
    data: data
  })
}

// 删除出库单主
export function delWmsOutboundOrder(orderId) {
  return request({
    url: '/ware/wmsOutboundOrder/' + orderId,
    method: 'delete'
  })
}
