import request from '@/utils/request'

// 查询盘点结果列表
export function listWmsInventoryResult(query) {
  return request({
    url: '/ware/wmsInventoryResult/list',
    method: 'get',
    params: query
  })
}

// 查询盘点结果详细
export function getWmsInventoryResult(resultId) {
  return request({
    url: '/ware/wmsInventoryResult/' + resultId,
    method: 'get'
  })
}

// 新增盘点结果
export function addWmsInventoryResult(data) {
  return request({
    url: '/ware/wmsInventoryResult',
    method: 'post',
    data: data
  })
}

// 修改盘点结果
export function updateWmsInventoryResult(data) {
  return request({
    url: '/ware/wmsInventoryResult',
    method: 'put',
    data: data
  })
}

// 删除盘点结果
export function delWmsInventoryResult(resultId) {
  return request({
    url: '/ware/wmsInventoryResult/' + resultId,
    method: 'delete'
  })
}
