import request from '@/utils/request'

// 查询库存流水列表
export function listWmsInventoryFlow(query) {
  return request({
    url: '/ware/wmsInventoryFlow/list',
    method: 'get',
    params: query
  })
}

// 查询库存流水详细
export function getWmsInventoryFlow(flowId) {
  return request({
    url: '/ware/wmsInventoryFlow/' + flowId,
    method: 'get'
  })
}

// 新增库存流水
export function addWmsInventoryFlow(data) {
  return request({
    url: '/ware/wmsInventoryFlow',
    method: 'post',
    data: data
  })
}

// 修改库存流水
export function updateWmsInventoryFlow(data) {
  return request({
    url: '/ware/wmsInventoryFlow',
    method: 'put',
    data: data
  })
}

// 删除库存流水
export function delWmsInventoryFlow(flowId) {
  return request({
    url: '/ware/wmsInventoryFlow/' + flowId,
    method: 'delete'
  })
}
