import request from '@/utils/request'

// 查询库存列表
export function listWmsInventory(query) {
  return request({
    url: '/ware/wmsInventory/list',
    method: 'get',
    params: query
  })
}

// 查询库存详细
export function getWmsInventory(inventoryId) {
  return request({
    url: '/ware/wmsInventory/' + inventoryId,
    method: 'get'
  })
}

// 新增库存
export function addWmsInventory(data) {
  return request({
    url: '/ware/wmsInventory',
    method: 'post',
    data: data
  })
}

// 修改库存
export function updateWmsInventory(data) {
  return request({
    url: '/ware/wmsInventory',
    method: 'put',
    data: data
  })
}

// 删除库存
export function delWmsInventory(inventoryId) {
  return request({
    url: '/ware/wmsInventory/' + inventoryId,
    method: 'delete'
  })
}
