import request from '@/utils/request'

// 查询审批节点列表
export function listWmsApprovalNode(query) {
  return request({
    url: '/ware/wmsApprovalNode/list',
    method: 'get',
    params: query
  })
}

// 查询审批节点详细
export function getWmsApprovalNode(nodeId) {
  return request({
    url: '/ware/wmsApprovalNode/' + nodeId,
    method: 'get'
  })
}

// 新增审批节点
export function addWmsApprovalNode(data) {
  return request({
    url: '/ware/wmsApprovalNode',
    method: 'post',
    data: data
  })
}

// 修改审批节点
export function updateWmsApprovalNode(data) {
  return request({
    url: '/ware/wmsApprovalNode',
    method: 'put',
    data: data
  })
}

// 删除审批节点
export function delWmsApprovalNode(nodeId) {
  return request({
    url: '/ware/wmsApprovalNode/' + nodeId,
    method: 'delete'
  })
}
