import request from '@/utils/request'

// 查询预警记录列表
export function listWmsAlertRecord(query) {
  return request({
    url: '/ware/wmsAlertRecord/list',
    method: 'get',
    params: query
  })
}

// 查询预警记录详细
export function getWmsAlertRecord(recordId) {
  return request({
    url: '/ware/wmsAlertRecord/' + recordId,
    method: 'get'
  })
}

// 新增预警记录
export function addWmsAlertRecord(data) {
  return request({
    url: '/ware/wmsAlertRecord',
    method: 'post',
    data: data
  })
}

// 修改预警记录
export function updateWmsAlertRecord(data) {
  return request({
    url: '/ware/wmsAlertRecord',
    method: 'put',
    data: data
  })
}

// 删除预警记录
export function delWmsAlertRecord(recordId) {
  return request({
    url: '/ware/wmsAlertRecord/' + recordId,
    method: 'delete'
  })
}
