import request from '@/utils/request'

// 查询供应商列表
export function listWmsSupplier(query) {
  return request({
    url: '/ware/wmsSupplier/list',
    method: 'get',
    params: query
  })
}

// 查询供应商详细
export function getWmsSupplier(supplierId) {
  return request({
    url: '/ware/wmsSupplier/' + supplierId,
    method: 'get'
  })
}

// 新增供应商
export function addWmsSupplier(data) {
  return request({
    url: '/ware/wmsSupplier',
    method: 'post',
    data: data
  })
}

// 修改供应商
export function updateWmsSupplier(data) {
  return request({
    url: '/ware/wmsSupplier',
    method: 'put',
    data: data
  })
}

// 删除供应商
export function delWmsSupplier(supplierId) {
  return request({
    url: '/ware/wmsSupplier/' + supplierId,
    method: 'delete'
  })
}
