import request from '@/utils/request'

// 查询RFID批量操作列表
export function listWmsRfidBatchOperation(query) {
  return request({
    url: '/ware/wmsRfidBatchOperation/list',
    method: 'get',
    params: query
  })
}

// 查询RFID批量操作详细
export function getWmsRfidBatchOperation(operationId) {
  return request({
    url: '/ware/wmsRfidBatchOperation/' + operationId,
    method: 'get'
  })
}

// 新增RFID批量操作
export function addWmsRfidBatchOperation(data) {
  return request({
    url: '/ware/wmsRfidBatchOperation',
    method: 'post',
    data: data
  })
}

// 修改RFID批量操作
export function updateWmsRfidBatchOperation(data) {
  return request({
    url: '/ware/wmsRfidBatchOperation',
    method: 'put',
    data: data
  })
}

// 删除RFID批量操作
export function delWmsRfidBatchOperation(operationId) {
  return request({
    url: '/ware/wmsRfidBatchOperation/' + operationId,
    method: 'delete'
  })
}
