import request from '@/utils/request'

// 查询物资分类列表
export function listWmsMaterialCategory(query) {
  return request({
    url: '/ware/wmsMaterialCategory/list',
    method: 'get',
    params: query
  })
}

// 查询物资分类详细
export function getWmsMaterialCategory(categoryId) {
  return request({
    url: '/ware/wmsMaterialCategory/' + categoryId,
    method: 'get'
  })
}

// 新增物资分类
export function addWmsMaterialCategory(data) {
  return request({
    url: '/ware/wmsMaterialCategory',
    method: 'post',
    data: data
  })
}

// 修改物资分类
export function updateWmsMaterialCategory(data) {
  return request({
    url: '/ware/wmsMaterialCategory',
    method: 'put',
    data: data
  })
}

// 删除物资分类
export function delWmsMaterialCategory(categoryId) {
  return request({
    url: '/ware/wmsMaterialCategory/' + categoryId,
    method: 'delete'
  })
}
