import request from '@/utils/request'

// 查询物资属性列表
export function listWmsMaterialAttribute(query) {
  return request({
    url: '/ware/wmsMaterialAttribute/list',
    method: 'get',
    params: query
  })
}

// 查询物资属性详细
export function getWmsMaterialAttribute(attributeId) {
  return request({
    url: '/ware/wmsMaterialAttribute/' + attributeId,
    method: 'get'
  })
}

// 新增物资属性
export function addWmsMaterialAttribute(data) {
  return request({
    url: '/ware/wmsMaterialAttribute',
    method: 'post',
    data: data
  })
}

// 修改物资属性
export function updateWmsMaterialAttribute(data) {
  return request({
    url: '/ware/wmsMaterialAttribute',
    method: 'put',
    data: data
  })
}

// 删除物资属性
export function delWmsMaterialAttribute(attributeId) {
  return request({
    url: '/ware/wmsMaterialAttribute/' + attributeId,
    method: 'delete'
  })
}
