import request from '@/utils/request'

// 查询库位信息列表
export function listWmsLocation(query) {
  return request({
    url: '/ware/wmsLocation/list',
    method: 'get',
    params: query
  })
}

// 查询库位信息详细
export function getWmsLocation(locationId) {
  return request({
    url: '/ware/wmsLocation/' + locationId,
    method: 'get'
  })
}

// 新增库位信息
export function addWmsLocation(data) {
  return request({
    url: '/ware/wmsLocation',
    method: 'post',
    data: data
  })
}

// 修改库位信息
export function updateWmsLocation(data) {
  return request({
    url: '/ware/wmsLocation',
    method: 'put',
    data: data
  })
}

// 删除库位信息
export function delWmsLocation(locationId) {
  return request({
    url: '/ware/wmsLocation/' + locationId,
    method: 'delete'
  })
}
