import request from '@/utils/request'

// 查询借调管理列表
export function listWmsBorrowOrder(query) {
  return request({
    url: '/ware/wmsBorrowOrder/list',
    method: 'get',
    params: query
  })
}

// 查询借调管理详细
export function getWmsBorrowOrder(orderId) {
  return request({
    url: '/ware/wmsBorrowOrder/' + orderId,
    method: 'get'
  })
}

// 新增借调管理
export function addWmsBorrowOrder(data) {
  return request({
    url: '/ware/wmsBorrowOrder',
    method: 'post',
    data: data
  })
}

// 修改借调管理
export function updateWmsBorrowOrder(data) {
  return request({
    url: '/ware/wmsBorrowOrder',
    method: 'put',
    data: data
  })
}

// 删除借调管理
export function delWmsBorrowOrder(orderId) {
  return request({
    url: '/ware/wmsBorrowOrder/' + orderId,
    method: 'delete'
  })
}
