import request from '@/utils/request'

// 查询RFID标签列表
export function listWmsRfidTag(query) {
  return request({
    url: '/ware/wmsRfidTag/list',
    method: 'get',
    params: query
  })
}

// 查询RFID标签详细
export function getWmsRfidTag(tagId) {
  return request({
    url: '/ware/wmsRfidTag/' + tagId,
    method: 'get'
  })
}

// 新增RFID标签
export function addWmsRfidTag(data) {
  return request({
    url: '/ware/wmsRfidTag',
    method: 'post',
    data: data
  })
}

// 修改RFID标签
export function updateWmsRfidTag(data) {
  return request({
    url: '/ware/wmsRfidTag',
    method: 'put',
    data: data
  })
}

// 删除RFID标签
export function delWmsRfidTag(tagId) {
  return request({
    url: '/ware/wmsRfidTag/' + tagId,
    method: 'delete'
  })
}
