import request from '@/utils/request'

// 查询RFID标签定位记录列表
export function listWmsRfidLocation(query) {
  return request({
    url: '/ware/wmsRfidLocation/list',
    method: 'get',
    params: query
  })
}

// 查询RFID标签定位记录详细
export function getWmsRfidLocation(locationRecordId) {
  return request({
    url: '/ware/wmsRfidLocation/' + locationRecordId,
    method: 'get'
  })
}

// 新增RFID标签定位记录
export function addWmsRfidLocation(data) {
  return request({
    url: '/ware/wmsRfidLocation',
    method: 'post',
    data: data
  })
}

// 修改RFID标签定位记录
export function updateWmsRfidLocation(data) {
  return request({
    url: '/ware/wmsRfidLocation',
    method: 'put',
    data: data
  })
}

// 删除RFID标签定位记录
export function delWmsRfidLocation(locationRecordId) {
  return request({
    url: '/ware/wmsRfidLocation/' + locationRecordId,
    method: 'delete'
  })
}
