import request from '@/utils/request'

// 查询RFID标签卡主列表
export function listWmsRfidCard(query) {
  return request({
    url: '/ware/wmsRfidCard/list',
    method: 'get',
    params: query
  })
}

// 查询RFID标签卡主详细
export function getWmsRfidCard(cardId) {
  return request({
    url: '/ware/wmsRfidCard/' + cardId,
    method: 'get'
  })
}

// 新增RFID标签卡主
export function addWmsRfidCard(data) {
  return request({
    url: '/ware/wmsRfidCard',
    method: 'post',
    data: data
  })
}

// 修改RFID标签卡主
export function updateWmsRfidCard(data) {
  return request({
    url: '/ware/wmsRfidCard',
    method: 'put',
    data: data
  })
}

// 删除RFID标签卡主
export function delWmsRfidCard(cardId) {
  return request({
    url: '/ware/wmsRfidCard/' + cardId,
    method: 'delete'
  })
}
