import request from '@/utils/request'

// 查询RFID标签绑定记录列表
export function listWmsRfidBinding(query) {
  return request({
    url: '/ware/wmsRfidBinding/list',
    method: 'get',
    params: query
  })
}

// 查询RFID标签绑定记录详细
export function getWmsRfidBinding(bindingId) {
  return request({
    url: '/ware/wmsRfidBinding/' + bindingId,
    method: 'get'
  })
}

// 新增RFID标签绑定记录
export function addWmsRfidBinding(data) {
  return request({
    url: '/ware/wmsRfidBinding',
    method: 'post',
    data: data
  })
}

// 修改RFID标签绑定记录
export function updateWmsRfidBinding(data) {
  return request({
    url: '/ware/wmsRfidBinding',
    method: 'put',
    data: data
  })
}

// 删除RFID标签绑定记录
export function delWmsRfidBinding(bindingId) {
  return request({
    url: '/ware/wmsRfidBinding/' + bindingId,
    method: 'delete'
  })
}
