import request from '@/utils/request'

// 查询RFID批量操作明细列表
export function listWmsRfidBatchDetail(query) {
  return request({
    url: '/ware/wmsRfidBatchDetail/list',
    method: 'get',
    params: query
  })
}

// 查询RFID批量操作明细详细
export function getWmsRfidBatchDetail(detailId) {
  return request({
    url: '/ware/wmsRfidBatchDetail/' + detailId,
    method: 'get'
  })
}

// 新增RFID批量操作明细
export function addWmsRfidBatchDetail(data) {
  return request({
    url: '/ware/wmsRfidBatchDetail',
    method: 'post',
    data: data
  })
}

// 修改RFID批量操作明细
export function updateWmsRfidBatchDetail(data) {
  return request({
    url: '/ware/wmsRfidBatchDetail',
    method: 'put',
    data: data
  })
}

// 删除RFID批量操作明细
export function delWmsRfidBatchDetail(detailId) {
  return request({
    url: '/ware/wmsRfidBatchDetail/' + detailId,
    method: 'delete'
  })
}
