import request from '@/utils/request'

// 查询RFID天线列表
export function listWmsRfidAntenna(query) {
  return request({
    url: '/ware/wmsRfidAntenna/list',
    method: 'get',
    params: query
  })
}

// 查询RFID天线详细
export function getWmsRfidAntenna(antennaId) {
  return request({
    url: '/ware/wmsRfidAntenna/' + antennaId,
    method: 'get'
  })
}

// 新增RFID天线
export function addWmsRfidAntenna(data) {
  return request({
    url: '/ware/wmsRfidAntenna',
    method: 'post',
    data: data
  })
}

// 修改RFID天线
export function updateWmsRfidAntenna(data) {
  return request({
    url: '/ware/wmsRfidAntenna',
    method: 'put',
    data: data
  })
}

// 删除RFID天线
export function delWmsRfidAntenna(antennaId) {
  return request({
    url: '/ware/wmsRfidAntenna/' + antennaId,
    method: 'delete'
  })
}
