import request from '@/utils/request'

// 查询退库管理列表
export function listWmsReturnOrder(query) {
  return request({
    url: '/ware/wmsReturnOrder/list',
    method: 'get',
    params: query
  })
}

// 查询退库管理详细
export function getWmsReturnOrder(orderId) {
  return request({
    url: '/ware/wmsReturnOrder/' + orderId,
    method: 'get'
  })
}

// 新增退库管理
export function addWmsReturnOrder(data) {
  return request({
    url: '/ware/wmsReturnOrder',
    method: 'post',
    data: data
  })
}

// 修改退库管理
export function updateWmsReturnOrder(data) {
  return request({
    url: '/ware/wmsReturnOrder',
    method: 'put',
    data: data
  })
}

// 删除退库管理
export function delWmsReturnOrder(orderId) {
  return request({
    url: '/ware/wmsReturnOrder/' + orderId,
    method: 'delete'
  })
}
