import request from '@/utils/request'

// 查询出库单明细列表
export function listWmsOutboundOrderItem(query) {
  return request({
    url: '/ware/wmsOutboundOrderItem/list',
    method: 'get',
    params: query
  })
}

// 查询出库单明细详细
export function getWmsOutboundOrderItem(itemId) {
  return request({
    url: '/ware/wmsOutboundOrderItem/' + itemId,
    method: 'get'
  })
}

// 新增出库单明细
export function addWmsOutboundOrderItem(data) {
  return request({
    url: '/ware/wmsOutboundOrderItem',
    method: 'post',
    data: data
  })
}

// 修改出库单明细
export function updateWmsOutboundOrderItem(data) {
  return request({
    url: '/ware/wmsOutboundOrderItem',
    method: 'put',
    data: data
  })
}

// 删除出库单明细
export function delWmsOutboundOrderItem(itemId) {
  return request({
    url: '/ware/wmsOutboundOrderItem/' + itemId,
    method: 'delete'
  })
}
