import request from '@/utils/request'

// 查询操作效率统计列表
export function listWmsOperationStatistics(query) {
  return request({
    url: '/ware/wmsOperationStatistics/list',
    method: 'get',
    params: query
  })
}

// 查询操作效率统计详细
export function getWmsOperationStatistics(statId) {
  return request({
    url: '/ware/wmsOperationStatistics/' + statId,
    method: 'get'
  })
}

// 新增操作效率统计
export function addWmsOperationStatistics(data) {
  return request({
    url: '/ware/wmsOperationStatistics',
    method: 'post',
    data: data
  })
}

// 修改操作效率统计
export function updateWmsOperationStatistics(data) {
  return request({
    url: '/ware/wmsOperationStatistics',
    method: 'put',
    data: data
  })
}

// 删除操作效率统计
export function delWmsOperationStatistics(statId) {
  return request({
    url: '/ware/wmsOperationStatistics/' + statId,
    method: 'delete'
  })
}
