import request from '@/utils/request'

// 查询出入库操作记录列表
export function listWmsOperationRecord(query) {
  return request({
    url: '/ware/wmsOperationRecord/list',
    method: 'get',
    params: query
  })
}

// 查询出入库操作记录详细
export function getWmsOperationRecord(recordId) {
  return request({
    url: '/ware/wmsOperationRecord/' + recordId,
    method: 'get'
  })
}

// 新增出入库操作记录
export function addWmsOperationRecord(data) {
  return request({
    url: '/ware/wmsOperationRecord',
    method: 'post',
    data: data
  })
}

// 修改出入库操作记录
export function updateWmsOperationRecord(data) {
  return request({
    url: '/ware/wmsOperationRecord',
    method: 'put',
    data: data
  })
}

// 删除出入库操作记录
export function delWmsOperationRecord(recordId) {
  return request({
    url: '/ware/wmsOperationRecord/' + recordId,
    method: 'delete'
  })
}
