import request from '@/utils/request'

// 查询移动作业任务列表
export function listWmsMobileTask(query) {
  return request({
    url: '/ware/wmsMobileTask/list',
    method: 'get',
    params: query
  })
}

// 查询移动作业任务详细
export function getWmsMobileTask(taskId) {
  return request({
    url: '/ware/wmsMobileTask/' + taskId,
    method: 'get'
  })
}

// 新增移动作业任务
export function addWmsMobileTask(data) {
  return request({
    url: '/ware/wmsMobileTask',
    method: 'post',
    data: data
  })
}

// 修改移动作业任务
export function updateWmsMobileTask(data) {
  return request({
    url: '/ware/wmsMobileTask',
    method: 'put',
    data: data
  })
}

// 删除移动作业任务
export function delWmsMobileTask(taskId) {
  return request({
    url: '/ware/wmsMobileTask/' + taskId,
    method: 'delete'
  })
}
