import request from '@/utils/request'

// 查询物资主数据列表
export function listWmsMaterial(query) {
  return request({
    url: '/ware/wmsMaterial/list',
    method: 'get',
    params: query
  })
}

// 查询物资主数据详细
export function getWmsMaterial(materialId) {
  return request({
    url: '/ware/wmsMaterial/' + materialId,
    method: 'get'
  })
}

// 新增物资主数据
export function addWmsMaterial(data) {
  return request({
    url: '/ware/wmsMaterial',
    method: 'post',
    data: data
  })
}

// 修改物资主数据
export function updateWmsMaterial(data) {
  return request({
    url: '/ware/wmsMaterial',
    method: 'put',
    data: data
  })
}

// 删除物资主数据
export function delWmsMaterial(materialId) {
  return request({
    url: '/ware/wmsMaterial/' + materialId,
    method: 'delete'
  })
}
