import request from '@/utils/request'

// 查询货架信息列表
export function listWmsLocation(query) {
  return request({
    url: '/ware/wmsLocation/list',
    method: 'get',
    params: query
  })
}

// 查询货架信息详细
export function getWmsLocation(locationId) {
  return request({
    url: '/ware/wmsLocation/' + locationId,
    method: 'get'
  })
}

// 新增货架信息
export function addWmsLocation(data) {
  return request({
    url: '/ware/wmsLocation',
    method: 'post',
    data: data
  })
}

// 修改货架信息
export function updateWmsLocation(data) {
  return request({
    url: '/ware/wmsLocation',
    method: 'put',
    data: data
  })
}

// 删除货架信息
export function delWmsLocation(locationId) {
  return request({
    url: '/ware/wmsLocation/' + locationId,
    method: 'delete'
  })
}
