import request from '@/utils/request'

// 查询盘点任务列表
export function listWmsInventoryTask(query) {
  return request({
    url: '/ware/wmsInventoryTask/list',
    method: 'get',
    params: query
  })
}

// 查询盘点任务详细
export function getWmsInventoryTask(taskId) {
  return request({
    url: '/ware/wmsInventoryTask/' + taskId,
    method: 'get'
  })
}

// 新增盘点任务
export function addWmsInventoryTask(data) {
  return request({
    url: '/ware/wmsInventoryTask',
    method: 'post',
    data: data
  })
}

// 修改盘点任务
export function updateWmsInventoryTask(data) {
  return request({
    url: '/ware/wmsInventoryTask',
    method: 'put',
    data: data
  })
}

// 删除盘点任务
export function delWmsInventoryTask(taskId) {
  return request({
    url: '/ware/wmsInventoryTask/' + taskId,
    method: 'delete'
  })
}
