import request from '@/utils/request'

// 查询盘点计划列表
export function listWmsInventoryPlan(query) {
  return request({
    url: '/ware/wmsInventoryPlan/list',
    method: 'get',
    params: query
  })
}

// 查询盘点计划详细
export function getWmsInventoryPlan(planId) {
  return request({
    url: '/ware/wmsInventoryPlan/' + planId,
    method: 'get'
  })
}

// 新增盘点计划
export function addWmsInventoryPlan(data) {
  return request({
    url: '/ware/wmsInventoryPlan',
    method: 'post',
    data: data
  })
}

// 修改盘点计划
export function updateWmsInventoryPlan(data) {
  return request({
    url: '/ware/wmsInventoryPlan',
    method: 'put',
    data: data
  })
}

// 删除盘点计划
export function delWmsInventoryPlan(planId) {
  return request({
    url: '/ware/wmsInventoryPlan/' + planId,
    method: 'delete'
  })
}
