import request from '@/utils/request'

// 查询入库单主列表
export function listWmsInboundOrder(query) {
  return request({
    url: '/ware/wmsInboundOrder/list',
    method: 'get',
    params: query
  })
}

// 查询入库单主详细
export function getWmsInboundOrder(orderId) {
  return request({
    url: '/ware/wmsInboundOrder/' + orderId,
    method: 'get'
  })
}

// 新增入库单
export function addWmsInboundOrder(data) {
  return request({
    url: '/ware/wmsInboundOrder',
    method: 'post',
    data: data
  })
}
// 保存入库单
export function saveWmsInboundOrder(data) {
  return request({
    url: '/ware/wmsInboundOrder/saveInBound',
    method: 'post',
    data: data
  })
}
// 入库功能（添加到库存）
export function addToInventory(data) {
  return request({
    url: '/ware/wmsInboundOrder/addMy',
    method: 'post',
    data: data
  })
}

// 修改入库单
export function updateWmsInboundOrder(data) {
  return request({
    url: '/ware/wmsInboundOrder',
    method: 'put',
    data: data
  })
}
// 修改入库单明细
export function updateWmsInboundOrderItem(data) {
  return request({
    url: '/ware/wmsInboundOrder/updateItem',
    method: 'put',
    data: data
  })
}


// 删除入库单主
export function delWmsInboundOrder(orderId) {
  return request({
    url: '/ware/wmsInboundOrder/' + orderId,
    method: 'delete'
  })
}

export function delWmsInboundOrderItem(orderId, itemId) {
  return request({
    url: '/ware/wmsInboundOrder/deleteItem/' + orderId + '/' + itemId,
    method: 'delete'
  })
}
