import request from '@/utils/request'

// 查询客户列表
export function listWmsCustomer(query) {
  return request({
    url: '/ware/wmsCustomer/list',
    method: 'get',
    params: query
  })
}

// 查询客户详细
export function getWmsCustomer(customerId) {
  return request({
    url: '/ware/wmsCustomer/' + customerId,
    method: 'get'
  })
}

// 新增客户
export function addWmsCustomer(data) {
  return request({
    url: '/ware/wmsCustomer',
    method: 'post',
    data: data
  })
}

// 修改客户
export function updateWmsCustomer(data) {
  return request({
    url: '/ware/wmsCustomer',
    method: 'put',
    data: data
  })
}

// 删除客户
export function delWmsCustomer(customerId) {
  return request({
    url: '/ware/wmsCustomer/' + customerId,
    method: 'delete'
  })
}
