import request from '@/utils/request'

// 查询库区信息列表
export function listWmsArea(query) {
  return request({
    url: '/ware/wmsArea/list',
    method: 'get',
    params: query
  })
}

// 查询库区信息详细
export function getWmsArea(areaId) {
  return request({
    url: '/ware/wmsArea/' + areaId,
    method: 'get'
  })
}

// 新增库区信息
export function addWmsArea(data) {
  return request({
    url: '/ware/wmsArea',
    method: 'post',
    data: data
  })
}

// 修改库区信息
export function updateWmsArea(data) {
  return request({
    url: '/ware/wmsArea',
    method: 'put',
    data: data
  })
}

// 删除库区信息
export function delWmsArea(areaId) {
  return request({
    url: '/ware/wmsArea/' + areaId,
    method: 'delete'
  })
}
