import request from '@/utils/request'

// 查询审批记录列表
export function listWmsApprovalRecord(query) {
  return request({
    url: '/ware/wmsApprovalRecord/list',
    method: 'get',
    params: query
  })
}

// 查询审批记录详细
export function getWmsApprovalRecord(recordId) {
  return request({
    url: '/ware/wmsApprovalRecord/' + recordId,
    method: 'get'
  })
}

// 新增审批记录
export function addWmsApprovalRecord(data) {
  return request({
    url: '/ware/wmsApprovalRecord',
    method: 'post',
    data: data
  })
}

// 修改审批记录
export function updateWmsApprovalRecord(data) {
  return request({
    url: '/ware/wmsApprovalRecord',
    method: 'put',
    data: data
  })
}

// 删除审批记录
export function delWmsApprovalRecord(recordId) {
  return request({
    url: '/ware/wmsApprovalRecord/' + recordId,
    method: 'delete'
  })
}
