import request from '@/utils/request'

// 查询仓库信息列表
export function listWmsWarehouse(query) {
  return request({
    url: '/ware/wmsWarehouse/list',
    method: 'get',
    params: query
  })
}

// 查询仓库信息详细
export function getWmsWarehouse(warehouseId) {
  return request({
    url: '/ware/wmsWarehouse/' + warehouseId,
    method: 'get'
  })
}

// 新增仓库信息
export function addWmsWarehouse(data) {
  return request({
    url: '/ware/wmsWarehouse',
    method: 'post',
    data: data
  })
}

// 修改仓库信息
export function updateWmsWarehouse(data) {
  return request({
    url: '/ware/wmsWarehouse',
    method: 'put',
    data: data
  })
}

// 删除仓库信息
export function delWmsWarehouse(warehouseId) {
  return request({
    url: '/ware/wmsWarehouse/' + warehouseId,
    method: 'delete'
  })
}
