import request from '@/utils/request'

// 查询RFID绑定历史列表
export function listWmsRfidBindingHistory(query) {
  return request({
    url: '/ware/wmsRfidBindingHistory/list',
    method: 'get',
    params: query
  })
}

// 查询RFID绑定历史详细
export function getWmsRfidBindingHistory(historyId) {
  return request({
    url: '/ware/wmsRfidBindingHistory/' + historyId,
    method: 'get'
  })
}

// 新增RFID绑定历史
export function addWmsRfidBindingHistory(data) {
  return request({
    url: '/ware/wmsRfidBindingHistory',
    method: 'post',
    data: data
  })
}

// 修改RFID绑定历史
export function updateWmsRfidBindingHistory(data) {
  return request({
    url: '/ware/wmsRfidBindingHistory',
    method: 'put',
    data: data
  })
}

// 删除RFID绑定历史
export function delWmsRfidBindingHistory(historyId) {
  return request({
    url: '/ware/wmsRfidBindingHistory/' + historyId,
    method: 'delete'
  })
}
