import request from '@/utils/request'

// 查询入库单明细列表
export function listWmsInboundOrderItem(query) {
  return request({
    url: '/ware/wmsInboundOrderItem/list',
    method: 'get',
    params: query
  })
}

// 查询入库单明细详细
export function getWmsInboundOrderItem(itemId) {
  return request({
    url: '/ware/wmsInboundOrderItem/' + itemId,
    method: 'get'
  })
}

// 新增入库单明细
export function addWmsInboundOrderItem(data) {
  return request({
    url: '/ware/wmsInboundOrderItem',
    method: 'post',
    data: data
  })
}

// 修改入库单明细
export function updateWmsInboundOrderItem(data) {
  return request({
    url: '/ware/wmsInboundOrderItem',
    method: 'put',
    data: data
  })
}

// 删除入库单明细
export function delWmsInboundOrderItem(itemId) {
  return request({
    url: '/ware/wmsInboundOrderItem/' + itemId,
    method: 'delete'
  })
}
