import request from '@/utils/request'

// 查询设备管理列表
export function listWmsDevice(query) {
  return request({
    url: '/ware/wmsDevice/list',
    method: 'get',
    params: query
  })
}

// 查询设备管理详细
export function getWmsDevice(deviceId) {
  return request({
    url: '/ware/wmsDevice/' + deviceId,
    method: 'get'
  })
}

// 新增设备管理
export function addWmsDevice(data) {
  return request({
    url: '/ware/wmsDevice',
    method: 'post',
    data: data
  })
}

// 修改设备管理
export function updateWmsDevice(data) {
  return request({
    url: '/ware/wmsDevice',
    method: 'put',
    data: data
  })
}

// 删除设备管理
export function delWmsDevice(deviceId) {
  return request({
    url: '/ware/wmsDevice/' + deviceId,
    method: 'delete'
  })
}
