import request from '@/utils/request'

// 查询审批流程列表
export function listWmsApprovalFlow(query) {
  return request({
    url: '/ware/wmsApprovalFlow/list',
    method: 'get',
    params: query
  })
}

// 查询审批流程详细
export function getWmsApprovalFlow(flowId) {
  return request({
    url: '/ware/wmsApprovalFlow/' + flowId,
    method: 'get'
  })
}

// 新增审批流程
export function addWmsApprovalFlow(data) {
  return request({
    url: '/ware/wmsApprovalFlow',
    method: 'post',
    data: data
  })
}

// 修改审批流程
export function updateWmsApprovalFlow(data) {
  return request({
    url: '/ware/wmsApprovalFlow',
    method: 'put',
    data: data
  })
}

// 删除审批流程
export function delWmsApprovalFlow(flowId) {
  return request({
    url: '/ware/wmsApprovalFlow/' + flowId,
    method: 'delete'
  })
}
