import request from '@/utils/request'

// 查询预警规则列表
export function listWmsAlertRule(query) {
  return request({
    url: '/ware/wmsAlertRule/list',
    method: 'get',
    params: query
  })
}

// 查询预警规则详细
export function getWmsAlertRule(ruleId) {
  return request({
    url: '/ware/wmsAlertRule/' + ruleId,
    method: 'get'
  })
}

// 新增预警规则
export function addWmsAlertRule(data) {
  return request({
    url: '/ware/wmsAlertRule',
    method: 'post',
    data: data
  })
}

// 修改预警规则
export function updateWmsAlertRule(data) {
  return request({
    url: '/ware/wmsAlertRule',
    method: 'put',
    data: data
  })
}

// 删除预警规则
export function delWmsAlertRule(ruleId) {
  return request({
    url: '/ware/wmsAlertRule/' + ruleId,
    method: 'delete'
  })
}
