import 'package:flutter/material.dart';

///分割线
class Tip extends StatelessWidget {
  final String? text;
  final double? marginTop, marginBottom, marginLeft, marginRight;
  final MaterialColor? color;
  final double? width;

  const Tip(this.text,
      {super.key,
      this.width=double.infinity,
      this.color = Colors.orange,
      this.marginTop = 10,
      this.marginBottom = 0,
      this.marginLeft = 10,
      this.marginRight = 10});

  @override
  Widget build(BuildContext context) {
    return Container(
      width: width!,
      alignment: Alignment.centerLeft,
      margin: EdgeInsets.only(
          top: marginTop!,
          bottom: marginBottom!,
          left: marginLeft!,
          right: marginRight!),
      // margin: const EdgeInsets.only(left: 5, right: 10, top: 10),
      padding: const EdgeInsets.only(left: 5, right: 5, top: 3, bottom: 3),
      decoration: BoxDecoration(
        color: Colors.orange[50],
        borderRadius: const BorderRadius.all(Radius.circular(5)),
      ),
      child: Text(
        softWrap: true,
        text!,
        style: TextStyle(color: color!, fontSize: 13),
      ),
    );
  }
}
