// ignore_for_file: use_key_in_widget_constructors, library_private_types_in_public_api

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';

typedef OnChanged = void Function(String txt);

//意见框
class InputWidget extends StatefulWidget {
  const InputWidget({
    this.placeholder = '请输入备注说明',
    required this.onChanged,
    this.maxLength = 100,
    this.maxLines = 10,
  });

  final String placeholder;
  final OnChanged onChanged;
  final int maxLength;
  final int maxLines;

  @override
  _InputWidgetState createState() => _InputWidgetState();
}

class _InputWidgetState extends State<InputWidget> {
  String result = '';

  @override
  Widget build(BuildContext context) {
    return _textInput();
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
  }

  Widget _textInput() {
    return Stack(
      alignment: AlignmentDirectional.bottomEnd,
      children: [
        Container(
          height: 100,
          decoration: BoxDecoration(
            color: Colors.grey[100],
            borderRadius: const BorderRadius.only(
                bottomLeft: Radius.circular(20),
                bottomRight: Radius.circular(5),
                topLeft: Radius.circular(5),
                topRight: Radius.circular(20)),
          ),
          alignment: AlignmentDirectional.topStart,
          margin: const EdgeInsets.only(bottom: 10, left: 10, right: 10),
          child: CupertinoTextField(
            autofocus: false,
            placeholder: widget.placeholder,
            style: const TextStyle(fontSize: 14, color: Colors.black),
            decoration: const BoxDecoration(
              borderRadius: BorderRadius.only(
                  bottomLeft: Radius.circular(20),
                  bottomRight: Radius.circular(5),
                  topLeft: Radius.circular(5),
                  topRight: Radius.circular(20)),
            ),
            maxLines: widget.maxLines,
            maxLength: widget.maxLength,
            textInputAction: TextInputAction.unspecified,
            onChanged: (str) {
              setState(() {
                result = str;
                widget.onChanged(str);
              });
            },
          ),
        ),
        Container(
          margin: const EdgeInsets.only(bottom: 20, right: 20),
          child: Text.rich(TextSpan(children: [
            TextSpan(
                text: "${result.length} / ",
                style: const TextStyle(color: Colors.grey, fontSize: 14)),

            ///试题内容
            TextSpan(
                text: "${widget.maxLength}",
                style: const TextStyle(
                    fontSize: 16,
                    color: ColorConst.themeBgColor,
                    fontWeight: FontWeight.bold)),
          ])),
        )
      ],
    );
  }
}
