import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';

class FirstSmallRefreshWidget extends StatelessWidget {
  final String? progress;
  final String? text;

  const FirstSmallRefreshWidget({Key? key, this.progress, this.text})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Center(
        child: SizedBox(
      height: 120.0,
      width: 120.0,
      child: Card(
        elevation: 0,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: <Widget>[
            Container(
              width: 50.0,
              height: 50.0,
              padding: const EdgeInsets.all(5),
              margin: const EdgeInsets.only(bottom: 5),
              child: const CircularProgressIndicator(
                backgroundColor: ColorConst.themeBgColor,
              ),
            ),
            Container(
              alignment: Alignment.center,
              child: Text('${text ?? '正在加载...'}${progress ?? ''}'),
            ),
          ],
        ),
      ),
    ));
  }
}
