// ignore_for_file: file_names

import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';
import 'package:special_equipment_flutter/common/edgeInsets_const.dart';
import 'package:special_equipment_flutter/common/font_size_const.dart';

typedef OnTap = Function();

class EmptyImgWidget extends StatelessWidget {
  final String? title;
  final OnTap? onTap;

  const EmptyImgWidget({Key? key, this.title, this.onTap}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return InkWell(
      child: Container(
        alignment: Alignment.center,
        padding: const EdgeInsets.symmetric(
            vertical: EdgeInsetsConst.padding_vertical,
            horizontal: EdgeInsetsConst.padding_horizontal),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: <Widget>[
            Image.asset(
              'assets/day/no_data_icon.png',
              width: 150.0,
              height: 150.0,
            ),
            Text(
              title ?? '暂无数据',
              style: const TextStyle(
                  fontSize: FontSizeConst.text_2s,
                  color: ColorConst.greyB2Color),
            ),
          ],
        ),
      ),
      onTap: () {
        if (onTap != null) {
          onTap!();
        }
      },
    );
  }
}
