// ignore_for_file: prefer_const_constructors_in_immutables

import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';

typedef OnConfirm = void Function();
typedef OnCancel = void Function();

class MessageDialog extends StatelessWidget {
  final String message;
  final Widget content;
  final String title;
  final String confirmTitle;
  final String cancelTitle;
  final OnConfirm onConfirm;
  final OnCancel onCancel;

  MessageDialog(
      {Key? key,
      required this.onConfirm,
      required this.onCancel,
      required this.message,
      required this.title,
      required this.confirmTitle,
      required this.cancelTitle,
      required this.content})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return AlertDialog(
      title: Text(title),
      content: content,
      actions: actions(context),
    );
  }

  List<Widget> actions(BuildContext context) {
    List<Widget> list = [];
    list.add(ElevatedButton(
        onPressed: () {
          onCancel();
        },
        child: Text(cancelTitle,
            style:
                const TextStyle(color: ColorConst.dark9Color, fontSize: 14))));
    list.add(ElevatedButton(
        onPressed: () {
          onConfirm();
        },
        child: Text(
          confirmTitle,
          style: const TextStyle(color: ColorConst.themeBgColor, fontSize: 18),
        )));
    return list;
  }
}
