import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';

class CustomBottomSheetTitleModel {
  final String title;

  final TextStyle? textStyle;

  final VoidCallback? onTapCallback;

  CustomBottomSheetTitleModel(this.title, {this.textStyle, this.onTapCallback});
}

/// 点击按钮回调
typedef CustomBottomSheetOnTapCallback = void Function(int index);

class CustomBottomSheet {
  /// 显示纯文字
  static Future<void> showTitleSheet(
      BuildContext context,
      List<CustomBottomSheetTitleModel> modelList,
      CustomBottomSheetOnTapCallback sheetOnTapCallback) async {
    return await showModalBottomSheet(
      context: context,
      backgroundColor: Colors.transparent, //重点 去除黑色背景颜色 实现圆角
      isScrollControlled: true, // 不限制高度
      builder: (BuildContext context) {
        return GestureDetector(
          behavior: HitTestBehavior.opaque,
          onTap: () {
            Navigator.of(context).pop();
          },
          child: Container(
            alignment: Alignment.bottomCenter,
            height: MediaQuery.of(context).size.height,
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Container(
                  height: 5,
                  width: 20,
                  decoration: const BoxDecoration(
                    color: Colors.white,
                    borderRadius: BorderRadius.all(Radius.circular(3)),
                  ),
                ),
                const SizedBox(height: 10),
                Container(
                  padding: const EdgeInsets.symmetric(vertical: 5),
                  decoration: const BoxDecoration(
                    color: Colors.white,
                    borderRadius: BorderRadius.only(
                      topLeft: Radius.circular(20),
                      topRight: Radius.circular(20),
                    ),
                  ),
                  child: MediaQuery.removePadding(
                      removeTop: true,
                      removeBottom: true,
                      context: context,
                      child: ListView.builder(
                        physics: const NeverScrollableScrollPhysics(),
                        itemCount: modelList.length,
                        shrinkWrap: true,
                        itemBuilder: (context, index) {
                          return InkWell(
                            onTap: () {
                              Navigator.of(context).pop();
                              sheetOnTapCallback(index);
                              if (index < modelList.length) {
                                modelList[index].onTapCallback?.call();
                              }
                            },
                            child: Container(
                              alignment: Alignment.center,
                              padding: const EdgeInsets.symmetric(vertical: 15),
                              child: Text(
                                modelList[index].title,
                                style: const TextStyle(
                                    color: ColorConst.themeBgColor,
                                    fontWeight: FontWeight.bold),
                              ),
                            ),
                          );
                        },
                      )),
                ),
                Container(
                  color: Colors.white,
                  child: InkWell(
                    onTap: () {
                      Navigator.of(context).pop();
                    },
                    child: Column(
                      children: [
                        Container(
                          height: 1,
                          color: Colors.grey[100],
                        ),
                        Container(
                          alignment: Alignment.center,
                          padding: const EdgeInsets.symmetric(vertical: 15),
                          child: const Text(
                            "取消",
                            style: TextStyle(color: Colors.black54),
                          ),
                        )
                      ],
                    ),
                  ),
                )
              ],
            ),
          ),
        );
      },
    );
  }
}
