import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/utils/string_utils.dart';
import 'package:special_equipment_flutter/widgets/divider_widget.dart';

///底部列表弹窗
Future<int?> showCustomModalBottomSheet(
    context, title, List<String> options) async {
  return showModalBottomSheet<int>(
    isScrollControlled: true,
    context: context,
    builder: (BuildContext context) {
      return Container(
        clipBehavior: Clip.antiAlias,
        decoration: const BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.only(
            topLeft: Radius.circular(10.0),
            topRight: Radius.circular(10.0),
          ),
        ),
        height: MediaQuery.of(context).size.height / 2.0,
        child: Column(children: [
          SizedBox(
            height: 50,
            child: Stack(
              textDirection: TextDirection.rtl,
              children: [
                Center(
                  child: Text(
                    StringUtils.strIsEmpty(title) ? '提示' : title,
                    style: const TextStyle(
                        fontWeight: FontWeight.bold, fontSize: 16.0),
                  ),
                ),
                IconButton(
                    icon: const Icon(Icons.close),
                    onPressed: () {
                      Navigator.of(context).pop();
                    }),
              ],
            ),
          ),
          const Divider(height: 1.0),
          Expanded(
            child: ListView.separated(
              itemBuilder: (BuildContext context, int index) {
                return ListTile(
                    title: Text(options[index]),
                    onTap: () {
                      Navigator.of(context).pop(index);
                    });
              },
              itemCount: options.length,
              separatorBuilder: (BuildContext context, int index) {
                return const DividerWidget();
              },
            ),
          ),
        ]),
      );
    },
  );
}
