import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/widgets/on_dialog_click_listener.dart';

class AlertDialogCustom {
  late OnDialogClickListener listener;

  static AlertDialog showDialog(String? title, String? content, {listener}) {
    return AlertDialog(
      title: Text(title!),
      content: Text(content!),
//      elevation: 10,
      //背景颜色
      backgroundColor: Colors.white,
      //设置圆角
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10)),
      actions: <Widget>[
        TextButton(
          child: const Text('取消'),
          onPressed: () {
            listener?.onCancel();
          },
        ),
        TextButton(
          child: const Text('确认'),
          onPressed: () {
            listener?.onConfirm();
          },
        ),
      ],
    );
  }
}
