import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:special_equipment_flutter/common/color_const.dart';

class CustomTextField extends StatefulWidget {
  String? title;
  String? hintText;
  bool? enabled, readOnly, isNoChinese, obscureText;
  int? maxLength;
  FocusNode? focusNode;
  TextInputType? textInputType; //文本框属性
  TextEditingController? controller = TextEditingController();

  Function()? onTop;
  Function(String text)? onChanged;

  CustomTextField(
      {super.key,
      this.title,
      this.hintText,
      this.maxLength,
      this.enabled,
      this.readOnly,
      this.controller,
      this.focusNode,
      this.isNoChinese = false,
      this.obscureText = false,
      this.textInputType = TextInputType.text,
      this.onTop,
      this.onChanged});

  @override
  State<CustomTextField> createState() => _CustomTextFieldState();
}

class _CustomTextFieldState extends State<CustomTextField> {
  String? title;
  String? hintText;
  int? maxLength;

  bool? enabled, readOnly, isNoChinese, obscureText;

  FocusNode? focusNode;
  TextInputType? textInputType; //文本框属性
  TextEditingController? controller = TextEditingController();

  Function()? onTop;
  Function(String text)? onChanged;
  Color _eyeColor = Colors.grey;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    title = widget.title;
    hintText = widget.hintText;
    enabled = widget.enabled;
    readOnly = widget.readOnly;
    isNoChinese = widget.isNoChinese;
    obscureText = widget.obscureText;
    focusNode = widget.focusNode;
    textInputType = widget.textInputType;
    controller = widget.controller;
    onTop = widget.onTop;
    onChanged = widget.onChanged;
    maxLength = widget.maxLength;
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 5, right: 5),

      ///输入框总高度
      height: 30,
      child: Row(
        children: <Widget>[
          Expanded(
              flex: 1,
              child: TextField(
                maxLength: maxLength,
                buildCounter: (BuildContext? context,
                        {int? currentLength,
                        int? maxLength,
                        bool? isFocused}) =>
                    null,
                obscureText: obscureText!,
                onChanged: onChanged,
                inputFormatters: isNoChinese! ? [_textInputFormatter()] : null,
                controller: controller,
                scrollPadding: EdgeInsets.zero,
                //焦点控制
                focusNode: focusNode,
                //输入框类型
                keyboardType: textInputType,
                enabled: enabled ?? false,
                readOnly: readOnly ?? false,
                onTap: readOnly! ? onTop : null,
                style: const TextStyle(fontSize: 14, color: Colors.black54),
                decoration: InputDecoration(
                    hintText: hintText,
                    contentPadding: const EdgeInsets.only(bottom: 15),
                    hintStyle: const TextStyle(
                        fontSize: 13, color: ColorConst.greyC2Color),
                    suffixIcon: hintText!.contains('密码')
                        ? IconButton(
                            icon: Icon(
                              Icons.remove_red_eye,
                              color: _eyeColor,
                            ),
                            iconSize: 20,
                            onPressed: () {
                              // 修改 state 内部变量, 且需要界面内容更新, 需要使用 setState()
                              setState(() {
                                obscureText = !obscureText!;
                                _eyeColor = (obscureText!
                                    ? Colors.grey
                                    : ColorConst.orangeColor);
                              });
                            },
                          )
                        : null),
              )),
          if (readOnly!) ...[
            const Icon(Icons.navigate_next, color: Colors.grey)
          ]
        ],
      ),
    );
  }
}

// class CustomTextField extends StatelessWidget {
//   String? title;
//   String? hintText;
//   bool? enabled, readOnly, isNoChinese, obscureText;
//
//   FocusNode? focusNode;
//   TextInputType? textInputType; //文本框属性
//   TextEditingController? controller = TextEditingController();
//
//   Function()? onTop;
//   Function(String text)? onChanged;
//   Color _eyeColor = Colors.grey;
//
//   CustomTextField(
//       {super.key,
//       this.title,
//       this.hintText,
//       this.enabled,
//       this.readOnly,
//       this.controller,
//       this.focusNode,
//       this.isNoChinese = false,
//       this.obscureText = false,
//       this.textInputType = TextInputType.text,
//       this.onTop,
//       this.onChanged});
//
//   @override
//   Widget build(BuildContext context) {
//     return Container(
//       margin: const EdgeInsets.only(left: 5, right: 5),
//
//       ///输入框总高度
//       height: 30,
//       child: Row(
//         children: <Widget>[
//           Expanded(
//               flex: 1,
//               child: TextField(
//                 // maxLength: 10,
//                 // buildCounter: (BuildContext? context,
//                 //         {int? currentLength,
//                 //         int? maxLength,
//                 //         bool? isFocused}) =>
//                 //     null,
//                 obscureText: obscureText!,
//                 onChanged: onChanged,
//                 inputFormatters: isNoChinese! ? [_textInputFormatter()] : null,
//                 controller: controller,
//                 scrollPadding: EdgeInsets.zero,
//                 //焦点控制
//                 focusNode: focusNode,
//                 //输入框类型
//                 keyboardType: textInputType,
//                 enabled: enabled ?? false,
//                 readOnly: readOnly ?? false,
//                 onTap: readOnly! ? onTop : null,
//                 style: const TextStyle(fontSize: 14, color: Colors.black54),
//                 decoration: InputDecoration(
//                     hintText: hintText,
//                     contentPadding: const EdgeInsets.only(bottom: 15),
//                     hintStyle: const TextStyle(
//                         fontSize: 13, color: ColorConst.greyC2Color),
//                     suffixIcon: IconButton(
//                       icon: Icon(
//                         Icons.remove_red_eye,
//                         color: _eyeColor,
//                       ),
//                       iconSize: 20,
//                       onPressed: () {
//                         // 修改 state 内部变量, 且需要界面内容更新, 需要使用 setState()
//                         setState(() {
//                           obscureText = !obscureText!;
//                           _eyeColor = (obscureText!
//                               ? Colors.grey
//                               : ColorConst.themeBgColor);
//                         });
//                       },
//                     )),
//               )),
//           if (readOnly!) ...[
//             const Icon(Icons.navigate_next, color: Colors.grey)
//           ]
//         ],
//       ),
//     );
//   }
// }

TextInputFormatter _textInputFormatter() {
  return FilteringTextInputFormatter.allow(RegExp("[^\u4E00-\u9FA5]"));
}
