// ignore_for_file: prefer_typing_uninitialized_variables, use_key_in_widget_constructors

import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:special_equipment_flutter/common/color_const.dart';

///列表item
class CustomListItem extends StatelessWidget {
  var asset;
  var title;
  var content;
  var content2;

  CustomListItem(this.asset, this.title, this.content, this.content2);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.fromLTRB(10, 0, 0, 5),
      child: Row(
        children: [
          const Icon(
            CupertinoIcons.location,
            size: 14,
            color: Colors.black54,
          ),
          const SizedBox(
            width: 5,
          ),
          Text.rich(
              softWrap: true,
              TextSpan(children: [
                TextSpan(
                    text: title,
                    style:
                        const TextStyle(fontSize: 13, color: Colors.black87)),
                TextSpan(
                  text: content,
                  style: TextStyle(fontSize: 13, color: Colors.grey[600]),
                ),
                if (content2 != null && content2 != "") ...[
                  TextSpan(
                    text: content2,
                    style: TextStyle(
                        fontSize: 12,
                        color: content2 == '有风险' || content2 == '不符合'
                            ? ColorConst.red1BgColor
                            : ColorConst.greenColor),
                  )
                ]
              ]))
        ],
      ),
    );
  }
}
